<?php $__env->startSection('title', 'Dashboard | ' .  Options::get('title') ); ?>

<?php $__env->startSection('content'); ?>

    <div class="content wow fadeInUp" data-wow-offset="1" data-wow-duration="01s" >

        <!--====  HEADER TOP  ====-->                    
        <div class="row content-header ">
            <div class="col-lg-4 col-md-6">
                <div class="ticket-small-box all-tickets">
                    <a href="<?php echo e(route('dashboard.tickets', 'all')); ?>">
                        <h4> All Tickets 
                            <span class="small-box-status"><?php echo e($new_ticket_counting); ?></span>
                        </h4>
                        <h2><?php echo e($all_ticket_counting); ?></h2>
                        <i class="ticket-box-bg-icon fa fa-file-text-o"></i>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="ticket-small-box solved-tickets">
                    <a href="<?php echo e(route('dashboard.tickets', 'solved')); ?>">
                        <h4>
                            Solved Tickets 
                        </h4>
                        <h2><?php echo e($solved_ticket_counting); ?></h2>
                        <i class="ticket-box-bg-icon fa fa-check-circle-o"></i>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="ticket-small-box pending-tickets">
                    <a href="<?php echo e(route('dashboard.tickets', 'pending')); ?>">
                        <h4>Pending Tickets</h4>
                        <h2><?php echo e($pending_ticket_counting); ?></h2>
                        <i class="ticket-box-bg-icon fa fa-hourglass-o"></i>
                    </a>
                </div>
            </div>
        </div>
        

        <!--====  BODY CONTENT  ====-->                    

        <div class="row content-body">
            
            <div class="ticket-box-row-first">


                    <!--====  TICKET BOX  ====-->
                <div class="col-md-12 col-lg-8 ticket-big-box-col">

                    
                    <div class="ticket-big-box recent-ticket-box">
                        <div class="box-title">
                            <div class="title-text pull-left">
                                <h3>Recent Tickets</h3>
                            </div>
                            <div class="box-action pull-right">
                                <span class="popover-wrapper right">
                                  <button data-role="popover" data-target="recent-tickets-action"><i class="fa fa-cog"></i></button>
                                  <div class="popover-modal recent-tickets-action">
                                    <div class="popover-body">
                                        <ul>
                                            <li><a href="<?php echo e(route('dashboard.tickets', 'all')); ?>">All Tickets</a></li>
                                            <li><a href="<?php echo e(route('dashboard.tickets', 'new')); ?>">New Tickets</a></li>
                                            <li><a href="<?php echo e(route('dashboard.tickets', 'pending')); ?>">Pending Tickets</a></li>
                                            <li><a href="<?php echo e(route('dashboard.tickets', 'solved')); ?>">Solved Tickets</a></li>
                                        </ul>
                                    </div>
                                  </div>
                                </span>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover responsive-table">
                                <thead>
                                    <tr>
                                        <th>Ticket ID</th>
                                        <th>Ticket title</th>
                                        <th>Department</th>
                                        <th>Date</th>
                                        <th>Client</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>

                                <?php /* Check if there's any tickets */ ?>
                                <?php if( count($tickets) ): ?>

                                    <?php /* Loop through over the tickets */ ?>
	                                <?php foreach($tickets as $ticket): ?>

		                                <tr>
		                                    <td>#<?php echo e($ticket->id); ?></td>

		                                    <td>
		                                    	<a href="<?php echo e(route('dashboard.single.ticket', [
                                                    'subject' => $ticket->FormatSubject(), 
                                                    'id' => $ticket->id
                                                ])); ?>">
		                                    		<?php echo e(str_limit($ticket->subject, 30)); ?>

		                                    	</a>
		                                    </td>

		                                    <td><?php echo e($ticket->getDepartment()); ?></td>
		                                    <td><?php echo e($ticket->created_at->diffForHumans()); ?></td>
		                                    <td><?php echo e($ticket->user->first_name); ?></td>
		                                    <td>
		                                        <span 
		                                        	class="status-<?php echo e($ticket->status); ?>">
		                                        	<?php echo e($ticket->status); ?>

		                                        </span>
		                                    </td>
		                                </tr>
	                                <?php endforeach; ?>
                                    <?php /* End the Loop */ ?>

                                <?php else: ?>

                                    <?php /* If no rows found */ ?>

                                	<tr>
                                		<td colspan="6" align="center">No tickets found</td>
                                	</tr>

                                <?php endif; ?>
                                <?php /* End the if condiction */ ?>
                            </table>                              
                        </div>
                    </div>
                </div>

                    <!--====  TICKET BOX  ====-->
                <div class="col-md-4 col-lg-4 ticket-big-box-col">
                    <div class="ticket-big-box">
                        <div class="box-title clearfix">
                            <div class="title-text pull-left">
                                <h3>New Clients</h3>
                            </div>
                            <div class="box-action pull-right">
                                <span class="popover-wrapper right">
                                  <button data-role="popover" data-target="new-clients-action"><i class="fa fa-cog"></i></button>
                                  <div class="popover-modal new-clients-action">
                                    <div class="popover-body">
                                        <ul>
                                            <li><a href="<?php echo e(route('dashboard.clients.all')); ?>">All Clients</a></li>
                                        </ul>
                                    </div>
                                  </div>
                                </span>
                            </div>
                        </div>
                        <ul class="clients-list">
                            <?php /* Check if there's any clients */ ?>

                        	<?php if( count( $clients) ): ?>
                                <?php /* Loop through over the clients */ ?>
                        		<?php foreach( $clients as $client ): ?>
		                            <li>    
		                                    <div class="client-list-img">
		                                        <img src="<?php echo e($client->profileImg(50)); ?>" alt="">
		                                    </div>
		                                    <div class="client-list-name">
		                                        <h4><?php echo e($client->fullName()); ?></h4>
		                                        <span><?php echo e($client->created_at->diffForHumans()); ?></span>
		                                    </div>
		                            </li>
		                        <?php endforeach; ?>
                                <?php /* End the loop */ ?>

                            <?php else: ?>
                                <?php /* If no rows found */ ?>

	                            <li>    
	                                <a href="">
	                                    <div class="client-list-name">
	                                        <h4>No clients</h4>
	                                    </div>
	                                </a>
	                            </li>
                            <?php endif; ?>
                            <?php /* End the if condiction */ ?>

                        </ul>
                    </div>
                </div>    
            </div>

            <!-- <div class="ticket-box-row-second"> -->
                
                    <!--====  TICKET BOX  ====-->
                <div class="col-md-8 col-lg-5 ticket-big-box-col">

                    
                    <div class="ticket-big-box ticket-staff-box">
                        <div class="box-title">
                            <div class="title-text pull-left">
                                <h3>Staff status</h3>
                            </div>
                            <div class="box-action pull-right">
                                <span class="popover-wrapper right">
                                  <button data-role="popover" data-target="staff-actions"><i class="fa fa-cog"></i></button>
                                  <div class="popover-modal staff-actions">
                                    <div class="popover-body">
                                        <ul>
                                            <li><a href="<?php echo e(route('dashboard.staffs.all')); ?>"> All Staffs</a></li>
                                        </ul>
                                    </div>
                                  </div>
                                </span>
                            </div>
                        </div> 

                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>                          
                                    <tr>
                                        <th>Staff name</th>
                                        <th>Department</th>
                                        <th>assigned task</th>
                                        <th>solved</th>
                                    </tr>
                                </thead>
                                <tbody>

                                <?php if( count( $staffs ) ): ?>
                                    <?php /* Loop through over the staffs */ ?>
                                    <?php foreach( $staffs as $staff ): ?>

                                        <tr>
                                            <td><?php echo e($staff->fullName()); ?></td>
                                            <td><?php echo e($staff->getDepartmentName()); ?></td>
                                            <td><?php echo e($staff->assignedTickets()->count()); ?></td>
                                            <td><?php echo e($staff->solvedTickets()->count()); ?></td>
                                        </tr>

                                    <?php endforeach; ?>
                                    <?php /* End the loop */ ?>

                                <?php else: ?>
                                    <?php /* If no rows found */ ?>

                                    <tr>
                                        <td colspan="4" align="center">No staffs found</td>
                                    </tr>
                                <?php endif; ?>
                                <?php /* End the if condiction */ ?>

                                </tbody>
                            </table>                             
                        </div>
                    </div>
                </div>


                    <!--====  TICKET BOX  ====-->
                <div class="col-lg-7 col-md-12 ticket-big-box-col">

                    
                    <div class="ticket-big-box statistics_box">
                        <div class="box-title clearfix">
                            <div class="title-text pull-left">
                                <h3>statistics of this month</h3>
                            </div>
                        </div>
                      <div class="chart">   
                        <div id="lineLegend"></div>
                        <canvas id="statisticsChart" ></canvas>
                      </div>
                    </div>
                </div>
            <!-- </div> -->

        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>

    <?php echo $__env->make('partials.dashboard.statistics', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>