<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;

class UpdateProfileRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $userId = \Auth::user()->id;
        return [
            'first_name'        => 'required|min:3',
            'last_name'         => 'required',
            'email'             => 'required|email|unique:users,email,' . $userId,
            'file'              => 'mimes:jpg,jpeg,bmp,png'
        ];
    }
}
