<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Department;
use App\Models\Option;
use App\Models\Role;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class HomeController extends HomeBaseController
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(Option $options)
    {
        parent::__construct();
        $this->options = $options;

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // If application is not installed
        if ( ! file_exists( storage_path('installed') ) ) {
            return redirect('install');
        } 

        // Get the theme style from database
        $style_option = $this->options
                        ->where('name', 'style')
                        ->first();

        // Get all departments
        $departments = Department::all();

        // Dynamically change view according to admin preference
        if( $style_option->value == 'homepage_style_1') {
            return view('home', compact('departments'));            
        } elseif( $style_option->value == 'homepage_style_2') {
            return view('homepage2', compact('departments'));            
        } else {
            return view('home', compact('departments'));            
        } 
    }


    /**
     *
     * Homepage style 2
     * @return View
     *
     */
    public function homepage2()
    {
        $departments = Department::all();
        return view('homepage2', compact('departments'));
    }


    /**
     *
     * User Settings Page
     * @return View
     *
     */
    public function settings()
    {
        $user = \Auth::user();
        return view('profile.settings', compact('user'));
    }


}
