<?php $__env->startSection('title', 'Login | ' . Options::get('title') ); ?>

<?php $__env->startSection('content'); ?>
<p class="title">Login here</p>

<div class="the-form">

    <?php echo e(Form::open(['url' => 'login', 'method' => 'post'])); ?>

        <div class="form-group">
            <div class="input-group">
              <span class="input-group-addon" id="email_addon">
                  <i class="fa fa-user"></i>
              </span>
                <?php echo e(Form::email('email', null, ['placeholder' => 'Email', 'class' => 'form-control', 'aria-describedby' => 'email_addon'])); ?>

            </div>
            <?php if( $errors->any() ): ?> 
                <span class="help-block"> <?php echo e($errors->first('email')); ?> </span>
            <?php endif; ?>
        </div>
        <div class="form-group">
            <div class="input-group">
                <span class="input-group-addon" id="password_addon">
                    <i class="fa fa-lock"></i>
                </span>
                <?php echo e(Form::password('password', ['placeholder' => 'Password', 'class' => 'form-control', 'aria-describedby' => 'password_addon'])); ?>

            </div>
            <?php if( $errors->any() ): ?> 
                <span class="help-block"> <?php echo e($errors->first('password')); ?> </span>
            <?php endif; ?>
        </div>


        <div class="form-group clearfix sp_check">
            <input type="checkbox" name="remember" id="remember">
            
            <label for="remember"> <span></span> Remember me? </label>
        </div>

        <?php echo e(Form::submit('login', ['class' => 'btn btn-success'])); ?>


        <div class="help-links">
            <p><a href="register">Register now</a></p>
            <p><a href="">Forget password?</a></p>
        </div>
    <?php echo e(Form::close()); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>