<!-- TICKET INFORMATAION -->
<div class="col-lg-4 col-md-12 ticket-information">
    <div class="ticket-box">
        <div class="ticket-header">
            <h4>Ticket information</h4>
        </div>
        <div class="ticket-info-body">
            <table class="table table-hover">
                <tr>
                    <th>Ticket id:</th>
                    <td>#<?php echo e($ticket->id); ?></td>
                </tr>
                <tr>
                    <th>Client:</th>
                    <td><?php echo e($ticket->user->fullName()); ?></td>
                </tr>
                <tr>
                    <th>Support Type:</th>
                    <td><?php echo e($ticket->getDepartment()); ?></td>
                </tr>
                <tr>
                    <th>Ticket status:</th>
                    <td class="template-ticket-status"><span class="status-<?php echo e($ticket->status); ?> "><?php echo e(ucwords($ticket->status)); ?></span></td>
                </tr>
                <tr>
                    <th>Assigned Staff:</th>
                    <td  class=" ticket-info-assigned-staff"> <?php echo e($ticket->getAssignedStaff()); ?> </td>
                </tr>
                <?php if( $ticket->solved_by ): ?>
                    <tr class="solved_by_staff">
                        <th>Solved By:</th>
                        <td  class=" ticket-info-solved-staff"> <?php echo e($ticket->getSolvedBy()); ?> </td>
                    </tr>
                <?php endif; ?>
            </table>
        </div>
        <div class="ticket-info-footer">
            <div class="ticket-info-buttons">
                <div class="as-n-s">
                    <button data-modal="modal-5" class="btn btn-info assign-new-trigger">Assign New Staff</button>
                    
                    <div class="assign-staff-up-box up-info-box ">
                        <h3>Assign This Ticket</h3>
                        <span class="up-box-cancel"><i class="fa fa-times"></i></span>
                        
                        <span class="up-box-status assign_upbox"><i class="fa fa-circle-o-notch status-success"></i></span>

                        <!-- ASSIGN TICKET POPUP TO ASSIGN THIS TICKET TO STAFF -->
                        <div class="box-form-outer scrollbar">
                            <?php echo e(Form::open([
                                'route' => ['ticket.assign.user', $ticket->id], 
                                'method' => 'post', 
                                'id' => 'ticket_assign_user'
                            ])); ?>


                                <?php if( count($staffs) ): ?>

                                    <?php foreach($staffs as $staff): ?>

                                        <!-- EACH STAFF IN THE LIST -->
                                        <div class="media assign-user-media">
                                            <label for="assign_user_<?php echo e($staff->id); ?>">

                                              <div class="media-left">
                                                  <img class="media-object" src="<?php echo e($staff->profileImg(40)); ?>" alt="Ohidul Islam">
                                              </div>
                                              <div class="media-body">
                                                <h4 class="media-heading"><?php echo e($staff->fullName()); ?></h4>
                                                <p><?php echo e($staff->role_name); ?></p>
                                                <div>
                                                    <input 
                                                        type="radio" 
                                                        name="assign_user" 
                                                        class="assign_user" 
                                                        value="<?php echo e($staff->id); ?>" 
                                                        id="assign_user_<?php echo e($staff->id); ?>"
                                                        <?php echo e($staff->fullName() == $ticket->getAssignedStaff() ? 'checked' : ''); ?>

                                                    >
                                                    <span class="input_radio"><i class="fa fa-check"></i></span>
                                                </div>
                                              </div>
                                            </label>
                                        </div>
                                    <?php endforeach; ?>

                                <?php else: ?>
                                    <div class="media">
                                        <label for="assign_user_none">

                                          <div class="media-body">
                                            <h4 class="media-heading">No Staff found</h4>
                                          </div>

                                        </label>
                                    </div>
                                <?php endif; ?>


                            </form>
                        </div>
                    </div>
                </div>

                <div class="as-n-u">
                    <button class="btn btn-success update_status_trigger">Update status</button>                                            

                    <div class="up-info-box update-status">
                        <h3>Update Ticket STatus</h3>
                        <span class="up-box-cancel"><i class="fa fa-times"></i></span>
                        <span class="up-box-status statusUpBx"><i class="fa fa-circle-o-notch fa-spin status-success"></i></span>

                        <!-- UPDATE TICKET STATUS POPUP -->
                        <div class="box-form-outer">                                                    
                            <?php echo e(Form::open([
                                'route' => ['update.ticket.status', $ticket->id],
                                'method' => 'post',
                                'id' => 'ticket_assign_form'
                            ])); ?>


                                <!-- UPDATE STATUS LIST -->
                                <div class="media">
                                    <label for="ticket_status_solved">

                                      <div class="media-body">
                                        <h4 class="media-heading">Solved</h4>
                                        <div>
                                            <input 
                                                type="radio" 
                                                name="ticket_status" 
                                                class="ticket_status <?php echo e($ticket->status == 'solved' ? 'checked' : ''); ?> " 
                                                value="solved" 
                                                id="ticket_status_solved"
                                                <?php echo e($ticket->status == 'solved' ? 'checked' : ''); ?>

                                            >
                                            <span class="input_radio"></span>
                                        </div>
                                      </div>
                                    </label>
                                </div>

                                    <!-- UPDATE STATUS LIST -->
                                <div class="media">
                                    <label for="ticket_status_pending">

                                      <div class="media-body">
                                        <h4 class="media-heading">Pending</h4>
                                        <div>
                                            <input 
                                                type="radio" 
                                                name="ticket_status" 
                                                class="ticket_status <?php echo e($ticket->status == 'pending' ? 'checked' : ''); ?>" 
                                                value="pending" 
                                                id="ticket_status_pending"
                                                <?php echo e($ticket->status == 'pending' ? 'checked' : ''); ?>

                                            >
                                            <span class="input_radio ticket_pending"></span>
                                        </div>
                                      </div>
                                    </label>
                                </div>

                            <?php echo e(Form::close()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>
</div>