@extends('layouts.dashboard')

@section('title', 'All Clients | ' . Options::get('title') )

@section('content')

                <div class="content">
                    <div class="row content-body">
                        

                        <!--  CLIENT BOX -->
                        <div class="ticket-box-row-first">
                            <div class="col-md-12  ticket-big-box-col">
                                <div class="staffs-p">
                                    <div class="box-title">
                                        <div class="title-text pull-left">
                                            <h3>Clients</h3>
                                        </div>
                                        
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-hover responsive-table">
                                            <thead>
                                                <tr>
                                                    <th>Name</th>
                                                    <th>Email</th>
                                                    <th class="text-center">Client Image</th>
                                                    <th>Registered at</th>
                                                    <th class=" text-center">Action</th>
                                                </tr>
                                            </thead>

                                            @if( count($clients) )

                                            	@foreach($clients as $client)

		                                            <tr class="client_row">
		                                                <td>{{ $client->fullName() }}</td>
		                                                <td><a href="mailto:{{ $client->email }}">{{ $client->email }}</a></td>
		                                                <td class="text-center tbl-img">
		                                                    <img src="{{ $client->profileImg(50) }}" alt="">
		                                                </td>
		                                                <td class="">{{ $client->created_at->diffForHumans() }}</td>
		                                                <td class="text-center tbl-btn">
                                                            <button class="client_remove remove-btn" type="submit" value="{{ $client->id }}"><i class="fa fa-times"></i></button>
		                                                </td>
		                                            </tr>

	                                            @endforeach

                                            @else
                                            	<tr>
                                            		<td colspan="6" align="center"> No clients to show. </td>
                                            	</tr>
                                            @endif

                                        </table>                              
                                    </div>

                                </div>

                                <!-- Pagination -->
                                {{ $clients->render() }}
                            </div>
                        </div>

                    </div>
                </div>

@stop
