<?php /* Dynamic site title */ ?>
<?php if( Request::get('term') ): ?>
    <?php $__env->startSection('title', 'Search for '.  Request::get('term') . ' | ' . Options::get('title')  ); ?>
<?php else: ?>
    <?php $__env->startSection('title', ucwords($view) . ' Tickets | ' . Options::get('title')  ); ?>
<?php endif; ?>


<?php $__env->startSection('content'); ?>

<div class="content">
    <div class="row content-body">

        <!-- TICKETS BOX -->
        <div class="ticket-box-row-first">
            <div class="col-md-12  ticket-big-box-col">
                <div class="ticket-big-box s-ticket-p recent-ticket-box">
                    <div class="box-title">
                        <div class="title-text pull-left">
                            <?php if( Request::get('term') ): ?>
                                <h3> Showing Search results for <i>'<?php echo e(Request::get('term')); ?>'</i> </h3>
                            <?php else: ?>
                                <h3> <?php echo e($view); ?> Tickets</h3>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover  responsive-table">
                            <thead>
                                <tr>
                                    <th>Ticket ID</th>
                                    <th>Ticket title</th>
                                    <th>Department</th>
                                    <th>Date</th>
                                    <th>Client</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>

                            <?php /* Check if there's any tickets */ ?>
                            <?php if( count($tickets) ): ?>
                                <?php /* Loop through over the tickets */ ?>
								<?php foreach( $tickets as $ticket ): ?>
    
		                            <tr class="ticket_row">
		                                <td>#<?php echo e($ticket->id); ?></td>
	                                	<td>
	                                    	<a href="<?php echo route('dashboard.single.ticket', [
                                                'subject' => $ticket->FormatSubject(), 
                                                'id' => $ticket->id
                                            ]); ?>">
	                                    		<?php echo e(str_limit($ticket->subject, 30)); ?>

	                                    	</a>
	                                    </td>
		                                <td><?php echo e($ticket->getDepartment()); ?></td>
		                                <td><?php echo e($ticket->created_at->diffForHumans()); ?></td>
		                                <td><?php echo e($ticket->user->fullName()); ?></td>
		                                <td>
		                                    <span class="status-<?php echo e($ticket->status); ?>">
		                                    	<?php echo e(ucwords($ticket->status)); ?>

		                                    </span>
		                                </td>
                                        <td>
                                            <button class="ticket_remove remove-btn" type="submit" value="<?php echo e($ticket->id); ?>"><i class="fa fa-times"></i></button>
                                        </td>
		                            </tr>

								<?php endforeach; ?>
                                <?php /* End the Loop */ ?>
	
                            <?php else: ?>
                                
                                <?php /* If no rows found */ ?>
                            	<tr>
                            		<td colspan="7" align="center"> No tickets found. </td>
                            	</tr>
                            	
                            <?php endif; ?>
                            <?php /* End the if condiction */ ?>

                        </table>                              
                    </div>
                </div>

                <?php echo e($tickets->appends(['term' => Request::get('term')])->render()); ?>

                
            </div>
        </div>

    </div>
</div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>