@extends('layouts.app')

@section('title', Options::get('title') )

@section('head_scripts')
    <!-- Google Recaptcha -->
        <script src='https://www.google.com/recaptcha/api.js'></script>
@stop


@section('content')

<div class="container">
<div class="search-pblm">
    <form action="">
        <div class="form-group">
            <input type="text" name="problem" id="problem" class="form-control" placeholder="Facing a problem? Try searching here...">            
            <button type="submit"><i class="fa fa-search"></i></button>      
        </div>
    </form>
</div>

<div class="ticket-area">
    <div class="row">
        <div class="col-md-7">
            <!-- Ticket submit form -->
            <div class="submit-ticket">
                <div class="heading-text">
                    <h2>Didn’t find what you want?  <span>Open a ticket now!</span></h2>
                    <p>We are very responsive in our service. You will get reply within 24 hours.</p>
                </div>

                @include('partials.site.ticket_form')

                        <div class="form_row hm_p_f_r">
                            <div class="form_half ">
                                <div class="ticket-submit-file">
                                    <input type="file" name="file" id="file-2" class="inputfile" data-multiple-caption="{count} files selected" />
                                    <label for="file-2"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="17" viewBox="0 0 20 17"><path d="M10 0l-5.2 4.9h3.3v5.1h3.8v-5.1h3.3l-5.2-4.9zm9.3 11.5l-3.2-2.1h-2l3.4 2.6h-3.5c-.1 0-.2.1-.2.1l-.8 2.3h-6l-.8-2.2c-.1-.1-.1-.2-.2-.2h-3.6l3.4-2.6h-2l-3.2 2.1c-.4.3-.7 1-.6 1.5l.6 3.1c.1.5.7.9 1.2.9h16.3c.6 0 1.1-.4 1.3-.9l.6-3.1c.1-.5-.2-1.2-.7-1.5z"/></svg> <span> <span class="browse">Browse</span> your file here&hellip;</span></label>
                                </div>
                            </div>

                            <div class="form_half form_gcaptha_controllable">
                                <div class="g-recaptcha" data-sitekey="{{ env('G_RECAPTCHA_KEY') }}"></div>
                            </div>
                        </div>

                        <div class="form-status "></div>


                        <div class="form-group ">
                            <input type="submit"  onclick="tinyMCE.triggerSave(true,true);"  value="Submit your ticket" class="btn btn-submit create-ticket-btn">
                        </div>

                    </form>
                
                </div>
                <!-- Ticket form ends -->
            </div>
            <!-- Ticket submit form ends -->
        </div>
        
        @include('partials.site.faq')
    </div>
</div>
</div>



@endsection


{{-- Include scripts --}}
@section('script')
    
    <script src="{{ URL::asset('assets/js/tinymce/tinymce.min.js') }}"></script>
    

    {{-- Including tinymce plugin load script --}}    
    @include('partials.site.homepage_tinymce_script')

@stop